unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, IdBaseComponent, IdComponent, IdTCPConnection, IdTCPClient,
  IdExplicitTLSClientServerBase, IdFTP, ComCtrls, ExtCtrls, IdAntiFreezeBase,
  IdAntiFreeze, IdHTTP;

type
  TForm1 = class(TForm)
    IdFTP1: TIdFTP;
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Button1: TButton;
    ListBox1: TListBox;
    Edit4: TEdit;
    Button2: TButton;
    Button3: TButton;
    Edit5: TEdit;
    Memo1: TMemo;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Button4: TButton;
    OpenDialog1: TOpenDialog;
    CheckBox1: TCheckBox;
    Timer1: TTimer;
    Button5: TButton;
    Button6: TButton;
    GroupBox3: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    procedure Button6Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure ListowanieKatalogu();
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
procedure TForm1.ListowanieKatalogu();
var ls: TStringList;
    i: integer;
begin
ListBox1.Clear;
ls:=TStringList.Create;
idFTP1.List(ls,'',true);
for i:=0 to ls.Count-1 do
  ListBox1.Items.Add(ls.Strings[i]);
Edit4.Text:=idFTP1.RetrieveCurrentDir;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
idFTP1.Host:=Edit1.Text;
idFTP1.Username:=Edit2.Text;
idFTP1.Password:=Edit3.Text;
try
  IdFTP1.Connect;
  Memo1.Lines.Add('Poczono si z '+Edit1.Text);
  Memo1.Lines.Add('Uytkownik='+Edit2.Text);
except on E:Exception do
 ShowMessage(E.Message);
end;
 ListowanieKatalogu;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
idFTP1.ChangeDirUp;
ListowanieKatalogu;
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
var wybor: String;
    ls: TStringList;
begin
ls:=TStringList.Create;
idFTP1.List(ls,'',false);
wybor:=ListBox1.Items[ListBox1.ItemIndex];
if wybor[1]='d' then
  begin
  idFTP1.ChangeDir(Edit4.Text+'/'+ls[ListBox1.ItemIndex]);
  ListowanieKatalogu;
  end;

end;

procedure TForm1.Button3Click(Sender: TObject);
var ls: TStringList;
begin
ls:=TStringList.Create;
idFTP1.List(ls,'',false);
Memo1.Lines.Add('Trwa pobieranie ...');
idFTP1.Get(Edit4.Text+'/'+ls[ListBox1.ItemIndex],Edit5.Text+ls[ListBox1.ItemIndex],false,false);
Memo1.Lines.Add('Pobieranie zakczone ...');
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
Memo1.Lines.Add('Trwa wysyanie ...');
if OpenDialog1.Execute then
if idFTP1.Connected then
begin
  try
  idFTP1.Put(OpenDialog1.FileName,ExtractFileName(OpenDialog1.FileName));
  Memo1.Lines.Add('Wysyanie zakczone ...');
  except on E:Exception do
    ShowMessage(E.Message);
  end;
end;
ListowanieKatalogu;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
idFTP1.Passive:=CheckBox1.Checked;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
if idFTP1.Connected then
  idFTP1.Noop;
end;

procedure TForm1.Button5Click(Sender: TObject);
var nazwa: String;
begin
if idFTP1.Connected then
begin
  nazwa:=inputbox('Utwrz nowy katalog','Nazwa Katalogu:','');
  if nazwa<>'' then
  try
  idFTP1.MakeDir(nazwa);
  ListowanieKatalogu;
  except on E:Exception do
    ShowMessage(E.Message);
  end;
end;
end;

procedure TForm1.Button6Click(Sender: TObject);
var ls: TStringList;
    wybor: String;
    klawisz: Integer;
begin
if idFTP1.Connected then
begin
  ls:=TStringList.Create;
  idFTP1.List(ls,'',false);
  klawisz:=MessageDlg('Czy napewno chcesz skasowa katalog: '+ls[ListBox1.ItemIndex],mtConfirmation, mbOKCancel, 0);
  if klawisz=mrOk then
  begin
    wybor:=ListBox1.Items[ListBox1.ItemIndex];
    if wybor[1]='d' then
    try
      idFTP1.RemoveDir(ls[ListBox1.ItemIndex]);
      ListowanieKatalogu;
    except on E:Exception do
      ShowMessage(E.Message);
    end;
  end;
end;
end;
end.
